/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.editor.common.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class RegexpRule
implements IPredicateRule {
    private Pattern regexp;
    private IToken successToken;
    private char firstChar = '\u0000';

    public RegexpRule(String regexp, IToken successToken) {
        this(regexp, successToken, false);
    }

    public RegexpRule(String regexp, IToken successToken, boolean matchFirstCharFirst) {
        this.regexp = Pattern.compile(regexp);
        this.successToken = successToken;
        if (matchFirstCharFirst && regexp.length() > 0) {
            block0 : switch (regexp.charAt(0)) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    break;
                }
                case '\\': {
                    switch (regexp.charAt(1)) {
                        case 'A': 
                        case 'B': 
                        case 'D': 
                        case 'G': 
                        case 'S': 
                        case 'W': 
                        case 'Z': 
                        case 'b': 
                        case 'd': 
                        case 's': 
                        case 'w': 
                        case 'z': {
                            break block0;
                        }
                    }
                    this.firstChar = regexp.charAt(1);
                    break;
                }
                default: {
                    this.firstChar = regexp.charAt(0);
                }
            }
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        String line;
        if (this.firstChar != '\u0000') {
            int readChar = scanner.read();
            scanner.unread();
            if (readChar == -1) {
                return Token.EOF;
            }
            if (this.firstChar != readChar) {
                return Token.UNDEFINED;
            }
        }
        if ((line = this.readNextLine(scanner)) == null) {
            return Token.EOF;
        }
        Matcher matcher = this.regexp.matcher(line);
        if (matcher.find() && matcher.start() == 0) {
            String match = matcher.group();
            if (match.length() < line.length()) {
                int toUnread = line.length() - match.length();
                this.unread(scanner, toUnread);
            }
            return this.successToken;
        }
        this.unread(scanner, line.length());
        return Token.UNDEFINED;
    }

    private void unread(ICharacterScanner scanner, int toUnread) {
        while (toUnread > 0) {
            scanner.unread();
            --toUnread;
        }
    }

    private String readNextLine(ICharacterScanner scanner) {
        int c;
        char[][] lineDelims = TextUtils.rsort(scanner.getLegalLineDelimiters());
        StringBuilder builder = new StringBuilder();
        while ((c = scanner.read()) != -1) {
            if (this.isLineDelim((char)c, lineDelims)) break;
            builder.append((char)c);
        }
        if (c == -1 && builder.length() == 0) {
            return null;
        }
        scanner.unread();
        return builder.toString();
    }

    private boolean isLineDelim(char c, char[][] lineDelims) {
        char[][] cArray = lineDelims;
        int n = lineDelims.length;
        int n2 = 0;
        while (n2 < n) {
            char[] lineDelim = cArray[n2];
            if (c == lineDelim[0]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

